/*
 * Decompiled with CFR 0.152.
 */
package org.autoplot.dom;

import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.autoplot.dom.Annotation;
import org.autoplot.dom.Application;
import org.autoplot.dom.Axis;
import org.autoplot.dom.DataSourceFilter;
import org.autoplot.dom.DomNode;
import org.autoplot.dom.DomUtil;
import org.autoplot.dom.Plot;
import org.autoplot.dom.PlotElement;
import org.autoplot.dom.PlotElementControllerUtil;
import org.das2.datum.Datum;
import org.das2.datum.DatumRange;
import org.das2.datum.DatumRangeUtil;
import org.das2.datum.OrbitDatumRange;
import org.das2.datum.Orbits;
import org.das2.datum.TimeParser;
import org.das2.datum.Units;
import org.das2.datum.UnitsUtil;
import org.das2.qds.DataSetUtil;
import org.das2.qds.QDataSet;
import org.das2.qds.ops.Ops;
import org.das2.util.LoggerManager;
import org.jdesktop.beansbinding.Converter;

public class LabelConverter
extends Converter {
    private static Logger logger = LoggerManager.getLogger((String)"autoplot.dom.labelConverter");
    Application dom = null;
    PlotElement plotElement = null;
    Plot plot = null;
    Annotation annotation = null;
    Axis axis = null;
    DomNode node = null;
    boolean multiplePEWarning = false;

    private LabelConverter() {
    }

    public LabelConverter(Application dom, Plot plot, Axis axis, PlotElement pe, Annotation an) {
        this();
        this.dom = dom;
        this.plot = plot;
        this.axis = axis;
        this.plotElement = pe;
        this.annotation = an;
    }

    public void setControlledNode(DomNode node) {
        this.node = node;
    }

    private PlotElement getFocusPlotElement() {
        PlotElement pe;
        this.multiplePEWarning = false;
        if (this.plotElement != null) {
            pe = this.plotElement;
        } else {
            List<PlotElement> pes = DomUtil.getPlotElementsFor(this.dom, this.plot);
            if (pes.size() == 1) {
                pe = pes.get(0);
            } else if (pes.isEmpty()) {
                pe = null;
            } else {
                pe = pes.get(0);
                this.multiplePEWarning = true;
            }
        }
        return pe;
    }

    public Object convertForward(Object value) {
        PlotElement pe = this.getFocusPlotElement();
        String title = (String)value;
        if (title.length() == 0) {
            return title;
        }
        boolean done = false;
        while (!done) {
            int newUnresolvedIndex;
            DataSourceFilter dsf;
            Map props;
            QDataSet dataSet;
            int unresolvedIndex = title.indexOf("%{");
            if (title.contains("CONTEXT")) {
                if (pe != null) {
                    QDataSet dataSet2;
                    int loopCount = 0;
                    if (pe.getController().isPendingChanges()) {
                        if (++loopCount > 1000) break;
                        try {
                            Thread.sleep(200L);
                        }
                        catch (InterruptedException ex) {
                            Logger.getLogger(LabelConverter.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                    if (loopCount > 1000) {
                        logger.warning("wait for isPendingChanges reached limit");
                    }
                    if ((dataSet2 = pe.getController().getDataSet()) != null) {
                        logger.log(Level.FINEST, "bug1814: context substitution success. {0}", Thread.currentThread().getName());
                        title = LabelConverter.insertUnformattedData(title, "CONTEXT", dataSet2);
                    } else {
                        logger.log(Level.FINEST, "bug1814: ds is null. {0}", Thread.currentThread().getName());
                        title = LabelConverter.insertString(title, "CONTEXT", "");
                    }
                } else {
                    logger.log(Level.FINEST, "bug1814: pe is null.{0}", Thread.currentThread().getName());
                    title = LabelConverter.insertString(title, "CONTEXT", "");
                }
            }
            if (title.contains("PLOT_CONTEXT")) {
                title = LabelConverter.insertString(title, "PLOT_CONTEXT", "%{CONTEXT}");
            }
            if (title.contains("USER_PROPERTIES") && pe != null && (dataSet = pe.getController().getDataSet()) != null && (props = (Map)dataSet.property("USER_PROPERTIES")) != null) {
                title = DomUtil.resolveProperties(title, "USER_PROPERTIES", props);
            }
            if (title.contains("METADATA") && pe != null && (dsf = (DataSourceFilter)DomUtil.getElementById(this.dom, pe.getDataSourceFilterId())) != null && (props = dsf.getController().getRawProperties()) != null) {
                title = DomUtil.resolveProperties(title, "METADATA", props);
            }
            if (title.contains("{PROPERTIES") && pe != null) {
                dataSet = pe.getController().getDataSet();
                int i1 = title.indexOf("{PROPERTIES") + 12;
                int i2 = title.indexOf(125, i1);
                String prop = title.substring(i1, i2);
                String[] ss = prop.split("\\.", -2);
                Object o = null;
                if (dataSet != null) {
                    for (String s : ss) {
                        o = dataSet.property(s);
                        if (o instanceof QDataSet) {
                            dataSet = (QDataSet)o;
                        }
                        if (o == null) break;
                    }
                }
                if (o == null) {
                    o = "";
                }
                title = LabelConverter.insertString(title, title.substring(i1 - 11, i2), o.toString());
            }
            if (title.contains("TIMERANGE")) {
                DatumRange tr = null;
                if (this.plot != null) {
                    if (this.axis != null && UnitsUtil.isTimeLocation((Units)this.axis.getRange().getUnits())) {
                        tr = this.axis.getRange();
                    } else if (UnitsUtil.isTimeLocation((Units)this.plot.getContext().getUnits())) {
                        tr = this.plot.getContext();
                    }
                }
                if (tr == null) {
                    tr = PlotElementControllerUtil.getTimeRange(this.dom, pe);
                }
                Pattern pop = Pattern.compile("(.*)\\%\\{TIMERANGE(.*?)\\}(.*)");
                String insert = tr == null ? "(no timerange)" : tr.toString();
                Matcher m = pop.matcher(title);
                if (m.matches()) {
                    String control = m.group(2).trim();
                    HashMap<String, String> controls = new HashMap<String, String>();
                    if (control.length() > 0) {
                        String[] ss;
                        char delim = control.charAt(0);
                        for (String s : ss = control.substring(1).split("\\" + delim)) {
                            int i = s.indexOf("=");
                            if (i == -1) {
                                controls.put(s, "");
                                continue;
                            }
                            controls.put(s.substring(0, i), s.substring(i + 1));
                        }
                    }
                    if (controls.size() > 0) {
                        Orbits o;
                        String s;
                        String context;
                        if (controls.containsKey("CONTEXT") && tr != null && (context = (String)controls.get("CONTEXT")) != null && (s = (o = Orbits.getOrbitsFor((String)context)).getOrbit(tr.middle())) != null) {
                            try {
                                DatumRange drtest = o.getDatumRange(s);
                                if (Math.abs(DatumRangeUtil.normalize((DatumRange)tr, (Datum)drtest.min())) < 0.05 && Math.abs(DatumRangeUtil.normalize((DatumRange)tr, (Datum)drtest.max()) - 1.0) < 0.05) {
                                    tr = DatumRangeUtil.parseTimeRange((String)("orbit:" + context + ":" + s));
                                }
                            }
                            catch (ParseException ex) {
                                logger.log(Level.SEVERE, null, ex);
                            }
                        }
                        if (controls.containsKey("NOORBIT")) {
                            if (tr != null) {
                                insert = tr instanceof OrbitDatumRange ? DatumRangeUtil.formatTimeRange((DatumRange)tr, (boolean)false) + " (Orbit " + ((OrbitDatumRange)tr).getOrbit() + ")" : DatumRangeUtil.formatTimeRange((DatumRange)tr, (boolean)false);
                            }
                        } else if (controls.containsKey("FORMAT")) {
                            String format = (String)controls.get("FORMAT");
                            if (format.equals("$o") || format.equals("%o")) {
                                insert = tr instanceof OrbitDatumRange ? ((OrbitDatumRange)tr).getOrbit() : "???";
                            } else {
                                TimeParser tp = TimeParser.create((String)format);
                                if (tr != null) {
                                    try {
                                        insert = tp.format(tr);
                                    }
                                    catch (IllegalArgumentException ex) {
                                        logger.warning(ex.getMessage());
                                        insert = tr.toString();
                                    }
                                }
                            }
                        }
                    }
                }
                title = LabelConverter.insertString(title, "TIMERANGE", insert);
            }
            if (title.contains("COMPONENT")) {
                String ss = "";
                if (pe != null) {
                    ss = pe.getComponent();
                }
                title = LabelConverter.insertString(title, "COMPONENT", ss);
            }
            done = (newUnresolvedIndex = title.indexOf("%{")) == -1 || newUnresolvedIndex == unresolvedIndex;
        }
        if (this.multiplePEWarning && !title.equals(value)) {
            logger.log(Level.FINE, "multiple plot elements found, using first to resolve: {0}", value);
        }
        return title;
    }

    public Object convertReverse(Object value) {
        String ptitle;
        String title = (String)value;
        if (title.length() == 0) {
            return title;
        }
        if (this.annotation != null) {
            ptitle = this.annotation.getText();
        } else if (this.plotElement != null) {
            PlotElement pe = this.getFocusPlotElement();
            ptitle = pe.getLegendLabel();
        } else {
            if (title.startsWith("xaxis")) {
                System.err.println("here xaxis");
            }
            if (this.node != null) {
                if (this.node == this.plot) {
                    ptitle = this.plot.getTitle();
                } else if (this.node == this.axis) {
                    ptitle = this.axis.getLabel();
                } else if (this.node == this.annotation) {
                    ptitle = this.annotation.getText();
                } else if (this.node == this.plotElement) {
                    PlotElement pe = this.getFocusPlotElement();
                    ptitle = pe.getLegendLabel();
                } else {
                    ptitle = this.plot.getTitle();
                }
            } else {
                ptitle = this.plot != null ? this.plot.getTitle() : this.axis.getLabel();
            }
        }
        if (LabelConverter.containsString(ptitle, "CONTEXT", title)) {
            title = ptitle;
        } else if (ptitle.contains("%{PLOT_CONTEXT}")) {
            title = ptitle;
        } else if (ptitle.contains("%{USER_PROPERTIES")) {
            title = ptitle;
        } else if (ptitle.contains("%{PROPERTIES")) {
            title = ptitle;
        } else if (ptitle.contains("%{METADATA")) {
            title = ptitle;
        } else if (LabelConverter.containsString(ptitle, "TIMERANGE", title)) {
            title = ptitle;
        } else if (LabelConverter.containsString(ptitle, "COMPONENT", title)) {
            title = ptitle;
        }
        if (this.multiplePEWarning && !title.equals(value)) {
            logger.log(Level.FINE, "multiple plot elements found, using first to resolve: {0}", value);
        }
        return title;
    }

    private static QDataSet findByName(String name, QDataSet context) {
        for (int i = 0; i < context.length(); ++i) {
            QDataSet d = context.slice(i);
            String n = Ops.guessName((QDataSet)d);
            if (n == null && d.rank() > 0) {
                n = Ops.guessName((QDataSet)d.slice(0));
            }
            if (n == null || !n.equals(name)) continue;
            return d;
        }
        return null;
    }

    protected static String insertUnformattedData(String title, String label, QDataSet dataset) {
        String svalue = DataSetUtil.contextAsString((QDataSet)dataset);
        Pattern p = Pattern.compile("(\\%\\{" + label + "(,(.*?))?\\})");
        Matcher m = p.matcher(title);
        boolean found = m.find();
        if (!found) {
            p = Pattern.compile("(\\$\\(" + label + "(,(.*?))?\\))");
            m = p.matcher(title);
            found = m.find();
        }
        if (found) {
            String args = m.group(3);
            if (args != null) {
                String[] aa;
                QDataSet ds = DataSetUtil.getContext((QDataSet)dataset);
                for (String a : aa = args.split(",", -2)) {
                    if (!a.startsWith("name=")) continue;
                    QDataSet ds1 = LabelConverter.findByName(a.substring(5), ds);
                    if (ds1 == null) {
                        svalue = "(notfound)";
                        continue;
                    }
                    ds = ds1;
                }
                if (ds.rank() > 1) {
                    if (ds.length() > 1) {
                        ds = ds.slice(0);
                        logger.warning("only 1 context supported");
                    } else if (ds.length() == 1) {
                        ds = ds.slice(0);
                    }
                }
                for (String a : aa) {
                    if (ds.length() <= 0 || svalue.equals("(notfound)") || !a.startsWith("format=") || args.length() <= 8) continue;
                    try {
                        if (a.charAt(7) == '$') {
                            TimeParser tp = TimeParser.create((String)a.substring(7));
                            if (ds.length() == 1) {
                                svalue = tp.format(Ops.datum((Object)ds.slice(0)));
                                continue;
                            }
                            if (ds.length() != 2) continue;
                            svalue = tp.format(Ops.datumRange((Object)ds.slice(0)));
                            continue;
                        }
                        if (a.endsWith("d") || a.endsWith("x")) {
                            svalue = String.format(a.substring(7), (int)ds.slice(0).value());
                            continue;
                        }
                        svalue = String.format(a.substring(7), ds.slice(0).value());
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        svalue = "(exception)";
                    }
                }
            }
            return title.substring(0, m.start()) + svalue + title.substring(m.end());
        }
        return title;
    }

    protected static String insertString(String title, String label, String value) {
        Pattern p = Pattern.compile("(\\%\\{" + label + "([,;].*?)?\\})");
        Matcher m = p.matcher(title);
        if (m.find()) {
            return title.substring(0, m.start()) + value + title.substring(m.end());
        }
        p = Pattern.compile("(\\$\\(" + label + "([,;].*?)?\\))");
        m = p.matcher(title);
        if (m.find()) {
            return title.substring(0, m.start()) + value + title.substring(m.end());
        }
        return title;
    }

    protected static boolean containsString(String title, String label, String value) {
        String[] ss = null;
        Pattern p = Pattern.compile("(\\%\\{" + label + "([,;].*)?\\})");
        Matcher m = p.matcher(title);
        if (m.find()) {
            ss = new String[]{title.substring(0, m.start()), title.substring(m.end())};
        } else {
            String search = "$(" + label + ")";
            if (title.contains(search)) {
                ss = title.split("\\$\\(" + label + "\\)", -2);
            }
        }
        return ss != null && value.startsWith(ss[0]) && value.endsWith(ss[1]);
    }
}

